package gov.va.genisis2.converter;

import static org.junit.Assert.assertEquals;

import java.util.ArrayList;
import java.util.List;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

import gov.va.genisis2.AbstractMockMvcTests;
import gov.va.genisis2.dto.StudyApprovalDTO;
import gov.va.genisis2.model.StudyApproval;
import gov.va.genisis2.util.DateUtil;
import gov.va.genisis2.vo.LdapStudyApproval;
import gov.va.genisis2.vo.LdapUser;

public class StudyApprovalConverterTest extends AbstractMockMvcTests {

	StudyApprovalConverter studyApprovalConverter;

	@Before
	public void setUp() {
		studyApprovalConverter = new StudyApprovalConverter();
	}

	@Test
	public void convert() {
		StudyApprovalDTO studyApprovalDTO = new StudyApprovalDTO();

		studyApprovalDTO.setId(1);
		studyApprovalDTO.setProcessId(3333);
		studyApprovalDTO.setObtained(null);
		studyApprovalDTO.setTitle("cs123");
		studyApprovalDTO.setDescription("cs123");
		studyApprovalDTO.setCreatedOn(DateUtil.getTodaysDate());
		studyApprovalDTO.setModifiedOn(DateUtil.getTodaysDate());
		studyApprovalDTO.setCreatedBy("GM123");
		studyApprovalDTO.setModifiedBy("GM123");

		List<Integer> associatedStudyApprovals = new ArrayList<>();
		associatedStudyApprovals.add(1);
		associatedStudyApprovals.add(2);
		associatedStudyApprovals.add(3);

		studyApprovalDTO.setAssociatedApprovals(associatedStudyApprovals);

		studyApprovalDTO.setActive((byte) 1);
		studyApprovalDTO.setActiveDate(DateUtil.getTodaysDate());
		studyApprovalDTO.setInactiveDate(DateUtil.getTodaysDate());

		assertEquals((byte) 1, (byte) studyApprovalConverter.convert(studyApprovalDTO).getActive());
	}

	@Test
	public void convert2() {
		StudyApproval studyApproval = new StudyApproval();

		studyApproval.setId(1);
		studyApproval.setProcessId(3333);
		studyApproval.setApprovalIdObtained("ff");
		studyApproval.setTitle("cs123");
		studyApproval.setDescription("cs123");
		studyApproval.setCreatedOn(DateUtil.getTodaysDate());
		studyApproval.setModifiedOn(DateUtil.getTodaysDate());
		studyApproval.setCreatedBy("GM123");
		studyApproval.setModifiedBy("GM123");
		studyApproval.setAssociatedStudyApproval1(1);
		studyApproval.setAssociatedStudyApproval2(2);
		studyApproval.setAssociatedStudyApproval3(3);
		studyApproval.setActive((byte) 1);
		studyApproval.setActiveDate(DateUtil.getTodaysDate());
		studyApproval.setInactiveDate(DateUtil.getTodaysDate());

		assertEquals((byte) 1, (byte) studyApprovalConverter.convert(studyApproval).getActive());
	}

	@Test
	public void convertStudyApprovals() {
		List<StudyApproval> studyApprovals = new ArrayList<>();

		StudyApproval studyApproval = new StudyApproval();

		studyApproval.setId(1);
		studyApproval.setProcessId(3333);
		studyApproval.setApprovalIdObtained("ff");
		studyApproval.setTitle("cs123");
		studyApproval.setDescription("cs123");
		studyApproval.setCreatedOn(DateUtil.getTodaysDate());
		studyApproval.setModifiedOn(DateUtil.getTodaysDate());
		studyApproval.setCreatedBy("GM123");
		studyApproval.setModifiedBy("GM123");
		studyApproval.setAssociatedStudyApproval1(1);
		studyApproval.setAssociatedStudyApproval2(2);
		studyApproval.setAssociatedStudyApproval3(3);
		studyApproval.setActive((byte) 1);
		studyApproval.setActiveDate(DateUtil.getTodaysDate());
		studyApproval.setInactiveDate(DateUtil.getTodaysDate());

		studyApprovals.add(studyApproval);

		Assert.assertTrue("The list null", studyApprovalConverter.convertStudyApprovals(studyApprovals).size() > 0);
	}

	@Test
	public void convert3() {
		LdapStudyApproval ldapStudyApproval = new LdapStudyApproval();

		ldapStudyApproval.setTitle("mpp333");
		ldapStudyApproval.setDescription("mpp333");

		assertEquals("mpp333", studyApprovalConverter.convert(ldapStudyApproval).getDescription());
	}

	@Test
	public void convert4() {
		LdapUser ldapUser = new LdapUser();

		ldapUser.setFirstName("Jojo");
		ldapUser.setLastName("Jo");
		ldapUser.setUsername("VAADMIN");

		ldapUser.setEmailId("email");

		assertEquals("VAADMIN", studyApprovalConverter.convert(ldapUser).getUsername());
	}

	@Test
	public void populate() {
		LdapStudyApproval ldapStudyApproval = new LdapStudyApproval();

		ldapStudyApproval.setTitle("mpp333");
		ldapStudyApproval.setDescription("mpp333");

		StudyApproval studyApproval = new StudyApproval();

		studyApproval.setId(1);
		studyApproval.setProcessId(3333);
		studyApproval.setApprovalIdObtained("ff");
		studyApproval.setTitle("mpp333");
		studyApproval.setDescription("mpp333");
		studyApproval.setCreatedOn(DateUtil.getTodaysDate());
		studyApproval.setModifiedOn(DateUtil.getTodaysDate());
		studyApproval.setCreatedBy("GM123");
		studyApproval.setModifiedBy("GM123");
		studyApproval.setAssociatedStudyApproval1(1);
		studyApproval.setAssociatedStudyApproval2(2);
		studyApproval.setAssociatedStudyApproval3(3);
		studyApproval.setActive((byte) 0);
		studyApproval.setActiveDate(DateUtil.getTodaysDate());
		studyApproval.setInactiveDate(DateUtil.getTodaysDate());

		studyApprovalConverter.populate(studyApproval, ldapStudyApproval);

	}
}
